<?php 

/*

Plugin Name: Custom Facebook Feed Pro Personal

Plugin URI: https://smashballoon.com/custom-facebook-feed

Description: Add a completely customizable Facebook feed to your WordPress site

Version: 3.15.2

Author: Smash Balloon

Author URI: http://smashballoon.com/

*/

/*

Copyright 2020  Smash Balloon  (email: hey@smashballoon.com)

This program is paid software; you may not redistribute it under any

circumstances without the expressed written consent of the plugin author.

This program is distributed in the hope that it will be useful,

but WITHOUT ANY WARRANTY; without even the implied warranty of

MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/





if ( function_exists('display_cff') ){

    wp_die( "Please deactivate the free version of the Custom Facebook Feed plugin before activating this version.<br /><br />Back to the WordPress <a href='".get_admin_url(null, 'plugins.php')."'>Plugins page</a>." );

} else {

    include dirname( __FILE__ ) .'/cff-init.php';

}

define( 'CFFVER', '3.15.2' );

define( 'CFFWELCOME_VER', '3.15.2' );

define( 'WPW_SL_STORE_URL', 'https://smashballoon.com/' );

define( 'WPW_SL_ITEM_NAME', 'Custom Facebook Feed WordPress Plugin Personal' ); //*!*Update Plugin Name at top of file*!*

// The ID of the product. Used for renewals

$cff_download_id = 210; //210, 299, 300, 13384

// Plugin Folder Path.

if ( ! defined( 'CFF_PLUGIN_DIR' ) ) {

	define( 'CFF_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

}

// Plugin Folder URL.

if ( ! defined( 'CFF_PLUGIN_URL' ) ) {

	define( 'CFF_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

}

if ( ! defined( 'CFF_DBVERSION' ) ) {

	define( 'CFF_DBVERSION', '1.2' );

}

if ( ! defined( 'CFF_UPLOADS_NAME' ) ) {

	define( 'CFF_UPLOADS_NAME', 'sb-facebook-feed-images' );

}

// Name of the database table that contains instagram posts

if ( ! defined( 'CFF_POSTS_TABLE' ) ) {

	define( 'CFF_POSTS_TABLE', 'cff_posts' );

}

// Name of the database table that contains feed ids and the ids of posts

if ( ! defined( 'CFF_FEEDS_POSTS_TABLE' ) ) {

	define( 'CFF_FEEDS_POSTS_TABLE', 'cff_feeds_posts' );

}

if ( ! defined( 'CFF_MAX_RECORDS' ) ) {

	define( 'CFF_MAX_RECORDS', 200 );

}

if ( ! defined( 'CFF_MINIMUM_WALL_VERSION' ) ) {

	define( 'CFF_MINIMUM_WALL_VERSION', '1.0' );

}

//

if( !class_exists( 'EDD_SL_Plugin_Updater' ) ) {

    // load our custom updater if it doesn't already exist

    include( dirname( __FILE__ ) . '/plugin_updater.php' );

}

function cff_plugin_updates() {

    // retrieve our license key from the DB

    $cff_license_key = trim( get_option( 'cff_license_key' ) );

    // setup the updater

    $edd_updater = new EDD_SL_Plugin_Updater( WPW_SL_STORE_URL, __FILE__, array( 

            'version'   => CFFVER,           // current version number

            'license'   => $cff_license_key,        // license key (used get_option above to retrieve from DB)

            'item_name' => WPW_SL_ITEM_NAME,    // name of this plugin

            'author'    => 'Smash Balloon'      // author of this plugin

        )

    );

}

add_action( 'admin_init', 'cff_plugin_updates', 0 );



//Run function on plugin activate

function cff_pro_activate( $network_wide ) {

    $options = get_option('cff_style_settings');



    //If the post types are all set to false then set them to be true as this likely means there was an issue with the settings not saving on activation

    if( !isset($options[ 'cff_show_links_type' ]) && !isset($options[ 'cff_show_event_type' ]) && !isset($options[ 'cff_show_video_type' ]) && !isset($options[ 'cff_show_photos_type' ]) && !isset($options[ 'cff_show_status_type' ]) && !isset($options[ 'cff_show_albums_type' ]) ){

        $options[ 'cff_show_links_type' ] = true;

        $options[ 'cff_show_event_type' ] = true;

        $options[ 'cff_show_video_type' ] = true;

        $options[ 'cff_show_photos_type' ] = true;

        $options[ 'cff_show_status_type' ] = true;

        $options[ 'cff_show_albums_type' ] = true;

    }



    //Show all parts of the feed by default on activation if they're all unset

    if( !isset($options[ 'cff_show_author' ]) && !isset($options[ 'cff_show_text' ]) && !isset($options[ 'cff_show_desc' ]) && !isset($options[ 'cff_show_shared_links' ]) && !isset($options[ 'cff_show_date' ]) && !isset($options[ 'cff_show_media' ]) && !isset($options[ 'cff_show_event_title' ]) && !isset($options[ 'cff_show_event_details' ]) && !isset($options[ 'cff_show_meta' ]) && !isset($options[ 'cff_show_link' ]) && !isset($options[ 'cff_show_facebook_link' ]) && !isset($options[ 'cff_show_facebook_share' ]) && !isset($options[ 'cff_event_title_link' ]) ){

        $options[ 'cff_show_author' ] = true;

        $options[ 'cff_show_text' ] = true;

        $options[ 'cff_show_desc' ] = true;

        $options[ 'cff_show_shared_links' ] = true;

        $options[ 'cff_show_date' ] = true;

        $options[ 'cff_show_media' ] = true;

        $options[ 'cff_show_event_title' ] = true;

        $options[ 'cff_show_event_details' ] = true;

        $options[ 'cff_show_meta' ] = true;

        $options[ 'cff_show_link' ] = true;

        $options[ 'cff_show_facebook_link' ] = true;

        $options[ 'cff_show_facebook_share' ] = true;

        $options[ 'cff_event_title_link' ] = true;

        $options[ 'cff_show_like_box' ] = true;

    }

    

    //Save the settings

    update_option( 'cff_style_settings', $options );



    //Set transient for welcome page

    set_transient( '_cff_activation_redirect', true, 30 );



    //Run cron twice daily when plugin is first activated for new users

	if ( ! wp_next_scheduled( 'cff_cron_job' ) ) {

		wp_schedule_event( time(), 'twicedaily', 'cff_cron_job' );

	}

	if ( ! wp_next_scheduled( 'cff_feed_issue_email' ) ) {

		$options = get_option( 'cff_style_settings' );



		$input = isset( $options[ 'email_notification' ] ) ? $options[ 'email_notification' ] : 'monday';

		$timestamp = strtotime( 'next ' . $input );

		$timestamp = $timestamp + (3600 * 24 * 7);



		$six_am_local = $timestamp + cff_get_utc_offset() + (6*60*60);



		wp_schedule_event( $six_am_local, 'cffweekly', 'cff_feed_issue_email' );

	}



	if ( is_multisite() && $network_wide && function_exists( 'get_sites' ) && class_exists( 'WP_Site_Query' ) ) {



		// Get all blogs in the network and activate plugin on each one

		$sites = get_sites();

		foreach ( $sites as $site ) {

			switch_to_blog( $site->blog_id );



			$upload     = wp_upload_dir();

			$upload_dir = $upload['basedir'];

			$upload_dir = trailingslashit( $upload_dir ) . CFF_UPLOADS_NAME;

			if ( ! file_exists( $upload_dir ) ) {

				$created = wp_mkdir_p( $upload_dir );

				if ( $created ) {

					//$sb_instagram_posts_manager->remove_error( 'upload_dir' );

				} else {

					/*$sb_instagram_posts_manager->add_error( 'upload_dir', array(

						__( 'There was an error creating the folder for storing resized images.', 'instagram-feed' ),

						$upload_dir

					) );*/

				}

			} else {

				//$sb_instagram_posts_manager->remove_error( 'upload_dir' );

			}



			cff_create_database_table();

			restore_current_blog();

		}



	} else {

		$upload     = wp_upload_dir();

		$upload_dir = $upload['basedir'];

		$upload_dir = trailingslashit( $upload_dir ) . CFF_UPLOADS_NAME;

		if ( ! file_exists( $upload_dir ) ) {

			$created = wp_mkdir_p( $upload_dir );

			if ( $created ) {

				//$sb_instagram_posts_manager->remove_error( 'upload_dir' );

			} else {

				/*$sb_instagram_posts_manager->add_error( 'upload_dir', array(

					__( 'There was an error creating the folder for storing resized images.', 'instagram-feed' ),

					$upload_dir

				) );*/

			}

		} else {

			//$sb_instagram_posts_manager->remove_error( 'upload_dir' );

		}



		cff_create_database_table();

	}

}

register_activation_hook( __FILE__, 'cff_pro_activate' );



function cff_pro_deactivate() {

    wp_clear_scheduled_hook('cff_cron_job');

}

register_deactivation_hook(__FILE__, 'cff_pro_deactivate');





//Uninstall

function cff_pro_uninstall()

{

    if ( ! current_user_can( 'activate_plugins' ) )

        return;



    //Delete avatar transients after uninstalling

    global $wpdb;

    $table_name = $wpdb->prefix . "options";

    $wpdb->query( "

        DELETE

        FROM $table_name

        WHERE `option_name` LIKE ('%\_transient\_fb\_avatar\_%')

        " );

    $wpdb->query( "

        DELETE

        FROM $table_name

        WHERE `option_name` LIKE ('%\_transient\_timeout\_fb\_avatar\_%')

        " );



    //If the user is preserving the settings then don't delete them

    $cff_preserve_settings = get_option('cff_preserve_settings');

    if($cff_preserve_settings) return;



    //Settings

    delete_option( 'cff_show_access_token' );

    delete_option( 'cff_access_token' );

    delete_option( 'cff_page_id' );

    delete_option( 'cff_page_type' );

    delete_option( 'cff_num_show' );

    delete_option( 'cff_post_limit' );

    delete_option( 'cff_show_others' );

    delete_option( 'cff_cache_time' );

    delete_option( 'cff_cache_time_unit' );

    delete_option( 'cff_locale' );

    delete_option( 'cff_ajax' );

    delete_option( 'cff_preserve_settings' );

    delete_option('cff_extensions_status');

    delete_option('cff_welcome_seen');



    //Style & Layout

    delete_option( 'cff_title_length' );

    delete_option( 'cff_body_length' );

    delete_option( 'cff_style_settings' );



    //Deactivate and delete license

    // retrieve the license from the database

    $license = trim( get_option( 'cff_license_key' ) );

    // data to send in our API request

    $api_params = array( 

        'edd_action'=> 'deactivate_license', 

        'license'   => $license, 

        'item_name' => urlencode( WPW_SL_ITEM_NAME ) // the name of our product in EDD

    );

    // Call the custom API.

    $response = wp_remote_get( add_query_arg( $api_params, WPW_SL_STORE_URL ), array( 'timeout' => 15, 'sslverify' => false ) );

    delete_option( 'cff_license_status' );

    delete_option( 'cff_license_key' );

	wp_clear_scheduled_hook( 'cff_feed_issue_email' );



	delete_option( 'cff_usage_tracking_config' );

	delete_option( 'cff_usage_tracking' );

	delete_option( 'cff_statuses' );

	delete_option( 'cff_rating_notice' );

	delete_option( 'cff_db_version' );



	global $wp_roles;

	$wp_roles->remove_cap( 'administrator', 'manage_custom_facebook_feed_options' );

	wp_clear_scheduled_hook( 'cff_usage_tracking_cron' );



	$upload = wp_upload_dir();



	global $wpdb;



	$posts_table_name = $wpdb->prefix . CFF_POSTS_TABLE;

	$feeds_posts_table_name = $wpdb->prefix . CFF_FEEDS_POSTS_TABLE;



	$image_files = glob( trailingslashit( $upload['basedir'] ) . trailingslashit( CFF_UPLOADS_NAME ) . '*'  ); // get all file names

	foreach ( $image_files as $file ) { // iterate files

		if ( is_file( $file ) ) {

			unlink( $file );

		}

	}



	//Delete tables

	$wpdb->query( "DROP TABLE IF EXISTS $posts_table_name" );

	$wpdb->query( "DROP TABLE IF EXISTS $feeds_posts_table_name" );



	global $wp_filesystem;



	$wp_filesystem->delete( trailingslashit( $upload['basedir'] ) . trailingslashit( 'sb-facebook-feed-images' ) , true );

}

register_uninstall_hook( __FILE__, 'cff_pro_uninstall' );



function cff_pro_cron_custom_interval( $schedules ) {

	$schedules['cffweekly'] = array(

		'interval' => 3600 * 24 * 7,

		'display'  => __( 'Weekly' )

	);



	return $schedules;

}

add_filter( 'cron_schedules', 'cff_pro_cron_custom_interval' );



function cff_pro_check_for_db_updates() {

	$db_ver = get_option( 'cff_db_version', 0 );



	if ( (float) $db_ver < 1.1 ) {

		if ( ! wp_next_scheduled( 'cff_feed_issue_email' ) ) {

			$timestamp = strtotime( 'next monday' );

			$timestamp = $timestamp + (3600 * 24 * 7);

			$six_am_local = $timestamp + get_option( 'gmt_offset', 0 ) * HOUR_IN_SECONDS + (6*60*60);



			wp_schedule_event( $six_am_local, 'cffweekly', 'cff_feed_issue_email' );

		}





		update_option( 'cff_db_version', CFF_DBVERSION );

	}



	if ( (float) $db_ver < 1.2 ) {

		$upload     = wp_upload_dir();

		$upload_dir = $upload['basedir'];

		$upload_dir = trailingslashit( $upload_dir ) . CFF_UPLOADS_NAME;

		if ( ! file_exists( $upload_dir ) ) {

			$created = wp_mkdir_p( $upload_dir );

			if ( $created ) {

				//$sb_instagram_posts_manager->remove_error( 'upload_dir' );

			} else {

				/*$sb_instagram_posts_manager->add_error( 'upload_dir', array(

					__( 'There was an error creating the folder for storing resized images.', 'instagram-feed' ),

					$upload_dir

				) );*/

			}

		} else {

			//$sb_instagram_posts_manager->remove_error( 'upload_dir' );

		}



		cff_create_database_table();



		update_option( 'cff_db_version', CFF_DBVERSION );

	}

}

add_action( 'wp_loaded', 'cff_pro_check_for_db_updates' );





function cff_create_database_table() {

	global $wpdb;

	global $wp_version;



	$table_name = esc_sql( $wpdb->prefix . CFF_POSTS_TABLE );

	$feeds_posts_table_name = esc_sql( $wpdb->prefix . CFF_FEEDS_POSTS_TABLE );

	$charset_collate = '';



	if ( version_compare( $wp_version, '3.5', '>' ) ) {

		$charset_collate = $wpdb->get_charset_collate();

	}



	if ( $wpdb->get_var( "show tables like '$table_name'" ) != $table_name ) {

		$sql = "CREATE TABLE " . $table_name . " (

                id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,

                facebook_id VARCHAR(1000) DEFAULT '' NOT NULL,

                created_on DATETIME,

                last_requested DATE,

                time_stamp DATETIME,

                json_data LONGTEXT DEFAULT '' NOT NULL,

                media_id VARCHAR(1000) DEFAULT '' NOT NULL,

                sizes VARCHAR(1000) DEFAULT '' NOT NULL,

                aspect_ratio DECIMAL (4,2) DEFAULT 0 NOT NULL,

                images_done TINYINT(1) DEFAULT 0 NOT NULL

            ) $charset_collate;";

		$wpdb->query( $sql );

	}



	if ( $wpdb->get_var( "show tables like '$feeds_posts_table_name'" ) != $feeds_posts_table_name ) {

		$sql = "CREATE TABLE " . $feeds_posts_table_name . " (

				record_id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,

                id INT(11) UNSIGNED NOT NULL,

                feed_id VARCHAR(1000) DEFAULT '' NOT NULL,

                INDEX feed_id (feed_id(100))

            ) $charset_collate;";

		$wpdb->query( $sql );

	}



	return $wpdb->get_var( "show tables like '$table_name'" ) === $table_name;

}